import UIKit

@IBDesignable class CustomClass: UIView
{
    @IBInspectable var lftColor : UIColor = UIColor.red
    @IBInspectable var ritColor : UIColor = UIColor.green
    @IBInspectable var midColor : UIColor = UIColor.blue
    @IBInspectable var midColorLoc : CGFloat = 0.5
    
    override func draw(_ rect: CGRect)    {
        let context = UIGraphicsGetCurrentContext()
        
        let colorsArr = [lftColor.cgColor, midColor.cgColor, ritColor.cgColor]
        let colorLocs = [0.0, midColorLoc, 1.0]
        
        let myGRadient = CGGradient (colorsSpace: CGColorSpaceCreateDeviceRGB(),
                                     colors: colorsArr as CFArray,
                                     locations: colorLocs)!

        let leftPoint = CGPoint.zero
        let rightPoint = CGPoint (x: bounds.width,
                                  y: 0)
        
        context?.drawLinearGradient(myGRadient,
                                    start: leftPoint,
                                    end: rightPoint,
                                    options: [])
    }
    
    
    
    
}


class ViewController: UIViewController {


}

